///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the ZCB Format exporter plug-in for Flexporter.
 *	\file		IceZCBExporter.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEZCBEXPORTER_H__
#define __ICEZCBEXPORTER_H__

	class ZCBFormat : public ExportFormat
	{
	public:
	// Constructor/Destructor
										ZCBFormat();
		virtual							~ZCBFormat();

	// Exporter init
		virtual	bool					Init(bool motion);

	// Main scene info
		virtual bool					SetSceneInfo		(const MainDescriptor& maininfo);

	// Export loop
				bool					ExportBasicInfo		(const ObjectDescriptor* obj, CustomArray* array);

		virtual bool					ExportCamera		(const CameraDescriptor& camera);
		virtual bool					ExportController	(const ControllerDescriptor& controller);
		virtual bool					ExportHelper		(const HelperDescriptor& helper);
		virtual bool					ExportLight			(const LightDescriptor& light);
		virtual bool					ExportMaterial		(const MaterialDescriptor& material);
		virtual bool					ExportMesh			(const MeshDescriptor& mesh);
		virtual bool					ExportMotion		(const MotionDescriptor& motion);
		virtual bool					ExportShape			(const ShapeDescriptor& shape);
		virtual bool					ExportTexture		(const TextureDescriptor& texture);

	// End of export notification
		virtual bool					EndExport			(const StatsDescriptor& stats);

	private:
	// Time info local copy
				MAXTimeInfo				mTimeInfo;
	// Export arrays
				CustomArray				mGeneral;
				CustomArray				mGeomObjects;
				CustomArray				mCameras;
				CustomArray				mLights;
				CustomArray				mShapes;
				CustomArray				mHelpers;
				CustomArray				mTexmaps;
				CustomArray				mMaterials;
				CustomArray				mControllers;
				CustomArray				mMotion;
	// Flags
				bool					mIsMotionFile;

	// Export a list of points
				bool					ExportFloats(MAXPoint* points, udword nbpoints, CustomArray& array, udword nbbits, bool keeplast);
	};

#endif // __ICEZCBEXPORTER_H__
